/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config;

import com.xzchaoo.commons.basic.config.Manager;
import com.xzchaoo.commons.basic.config.MapConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

final class Utils {
    Utils() {
    }

    static Map<String, String> propertiesToMap(Properties p) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : p.stringPropertyNames()) {
            map.put(key, p.getProperty(key));
        }
        return map;
    }

    static MapConfig fromPropertiesFile(Manager manager, File file) throws IOException {
        return Utils.fromPropertiesStream(manager, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MapConfig fromPropertiesStream(Manager manager, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        try {
            Properties p = new Properties();
            p.load(inputStream);
            MapConfig mapConfig = new MapConfig(manager, p);
            return mapConfig;
        }
        finally {
            inputStream.close();
        }
    }
}

