/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config.bind;

import com.xzchaoo.commons.basic.config.bind.ListValue;
import com.xzchaoo.commons.basic.config.bind.MapValue;
import com.xzchaoo.commons.basic.unsafe.UnsafeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Binder {
    private static final ClassValue<ClassData> CV = new ClassValue<ClassData>(){

        @Override
        protected ClassData computeValue(Class<?> type) {
            ClassData cd = new ClassData();
            ArrayList<FieldData> fds = new ArrayList<FieldData>();
            for (Class<?> t = type; t != null && t != Object.class; t = t.getSuperclass()) {
                for (Field f : t.getDeclaredFields()) {
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    FieldData fd = new FieldData();
                    fd.field = f;
                    fd.init();
                    fds.add(fd);
                }
            }
            cd.fields = fds.toArray(new FieldData[fds.size()]);
            return cd;
        }
    };
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(String.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Duration.class));
    private static final Set<Class<?>> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE));
    private static final ClassValue<OfValueData> OF_VALUE_DATA = new ClassValue<OfValueData>(){

        @Override
        protected OfValueData computeValue(Class<?> type) {
            OfValueData d = new OfValueData();
            try {
                Method method = type.getDeclaredMethod("ofValue", String.class);
                Class<?> returnType = method.getReturnType();
                if (type.isAssignableFrom(returnType)) {
                    d.ofValueMethod = method;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return d;
        }
    };

    public static Map<String, Object> convertToMapObject(Map<String, String> p) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, String> e : p.entrySet()) {
            Binder.set(map, e.getKey(), e.getValue(), 0);
        }
        return map;
    }

    private static void set(Map<String, Object> map, String key, String value, int offset) {
        String subKey;
        int nextIndex;
        int index = Binder.nextOffset(key, offset);
        if (index < 0) {
            nextIndex = -1;
            subKey = key.substring(offset);
        } else {
            char c;
            subKey = key.substring(offset, index);
            for (nextIndex = index + 1; nextIndex < key.length() && ((c = key.charAt(nextIndex)) == '.' || c == '[' || c == ']'); ++nextIndex) {
            }
            if (nextIndex == key.length()) {
                nextIndex = -1;
            }
        }
        subKey = Binder.format(subKey);
        if (nextIndex < 0) {
            map.put(subKey, value);
        } else {
            HashMap temp = map.get(subKey);
            if (temp == null) {
                temp = new HashMap();
                map.put(subKey, temp);
            } else if (!(temp instanceof Map)) {
                String invalidKey = key.substring(0, index);
                throw new IllegalStateException("key [" + invalidKey + "] is prefix of other key");
            }
            Map sub = temp;
            Binder.set(sub, key, value, nextIndex);
        }
    }

    static String format(String key) {
        StringBuilder sb = null;
        int offset = 0;
        while (offset < key.length()) {
            int index = key.indexOf(45, offset);
            if (index < 0) {
                if (offset != 0) break;
                return key;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(key, offset, index);
            if (index + 2 < key.length() && Character.isLetter(key.charAt(index + 1))) {
                sb.append(Character.toUpperCase(key.charAt(index + 1)));
                offset = index + 2;
                continue;
            }
            offset = index;
            break;
        }
        sb.append(key, offset, key.length());
        return sb.toString();
    }

    private Object convertToSimple(String value, Type t) {
        if (!(t instanceof Class)) {
            throw new IllegalStateException("t must be a class instance");
        }
        if (t == String.class || t == Object.class) {
            return value;
        }
        if (t == Integer.class || t == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (t == Long.class || t == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (t == Float.class || t == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (t == Double.class || t == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (t == Boolean.class || t == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (t == Duration.class) {
            return Binder.parseDuration(value);
        }
        try {
            Class c = (Class)t;
            OfValueData ofValueData = OF_VALUE_DATA.get(c);
            if (ofValueData.ofValueMethod != null) {
                return ofValueData.ofValueMethod.invoke(null, value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new RuntimeException("convert error");
    }

    private static Duration parseDuration(String str) {
        char u = str.charAt(str.length() - 1);
        long value = Long.parseLong(str.substring(0, str.length() - 1));
        switch (u) {
            case 's': {
                return Duration.ofSeconds(value);
            }
            case 'm': {
                return Duration.ofMinutes(value);
            }
            case 'h': {
                return Duration.ofHours(value);
            }
        }
        throw new IllegalArgumentException("fail to parse " + str + " to Duration");
    }

    private Object convertToKey(String value, Type type) {
        if (!(type instanceof Class)) {
            throw new IllegalStateException("Map key type must be a class instance");
        }
        Class c = (Class)type;
        if (type == String.class) {
            return value;
        }
        OfValueData ovd = OF_VALUE_DATA.get(c);
        if (ovd.ofValueMethod != null) {
            try {
                return ovd.ofValueMethod.invoke(null, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("fail to call ofValue to construct a key", e);
            }
        }
        throw new IllegalStateException("fail to create a key for type " + type);
    }

    private void bindSub(Map<String, ?> sub, Object obj, Type type) {
        if (obj instanceof Map) {
            if (!(type instanceof ParameterizedType)) {
                throw new RuntimeException("type must be ParameterizedType");
            }
            Type[] args = ((ParameterizedType)type).getActualTypeArguments();
            if (args[0] != String.class) {
                throw new IllegalStateException("Map key must be String");
            }
            Map mapObj = (Map)obj;
            for (Map.Entry<String, ?> e : sub.entrySet()) {
                Object mapValue;
                Object mapKey = this.convertToKey(e.getKey(), args[0]);
                if (e.getValue() instanceof Map) {
                    try {
                        mapValue = ((Class)args[1]).newInstance();
                        this.bindSub((Map)e.getValue(), mapValue, args[1]);
                        mapObj.put(mapKey, mapValue);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                mapValue = this.convertToSimple((String)e.getValue(), args[1]);
                mapObj.put(mapKey, mapValue);
            }
            return;
        }
        ClassData cd = CV.get(obj.getClass());
        for (FieldData field : cd.fields) {
            Object value = sub.get(field.field.getName());
            if (value == null) continue;
            Object fieldValue = this.convertToFieldValue(value, obj, field);
            field.set(obj, fieldValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object convertToFieldValue(Object value, Object obj, FieldData field) {
        Object fieldValue = field.get(obj);
        if (field.simple) {
            if (!(value instanceof String)) throw new IllegalStateException("value must be String " + value);
            return this.convertToSimple((String)value, field.field.getType());
        }
        if (field.collection) {
            String[] ss;
            Type t = field.field.getGenericType();
            if (!(t instanceof ParameterizedType)) {
                throw new RuntimeException("field must be a Collection<T>");
            }
            Type valueType = ((ParameterizedType)t).getActualTypeArguments()[0];
            if (!(value instanceof String)) {
                throw new IllegalStateException("value must be a String");
            }
            if (fieldValue == null) {
                fieldValue = this.newCollectionInstance(field);
            }
            Collection coll = (Collection)fieldValue;
            coll.clear();
            String separator = ",";
            ListValue listValueAn = field.field.getAnnotation(ListValue.class);
            if (listValueAn != null) {
                separator = listValueAn.separator();
            }
            String[] stringArray = ss = ((String)value).split(separator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                coll.add(this.convertToSimple(s, valueType));
                ++n2;
            }
            return fieldValue;
        }
        if (field.array) {
            return this.convertToArray(value, field);
        }
        if (fieldValue == null) {
            fieldValue = this.newFieldValue(field);
        }
        if (value instanceof String) {
            String sep1 = "=";
            String sep2 = "^";
            MapValue mv = field.field.getAnnotation(MapValue.class);
            if (mv != null) {
                sep1 = mv.sep1();
                sep2 = mv.sep2();
            }
            Map<String, String> parsedMap = Binder.parseToMap((String)value, sep1, sep2);
            this.bindSub(parsedMap, fieldValue, field.field.getGenericType());
        } else {
            if (!(value instanceof Map)) throw new IllegalStateException("value must be map " + value);
            this.bindSub((Map)value, fieldValue, field.field.getGenericType());
        }
        try {
            Method afterPropertiesSetMethod = fieldValue.getClass().getDeclaredMethod("afterPropertiesSet", new Class[0]);
            afterPropertiesSetMethod.invoke(fieldValue, new Object[0]);
            return fieldValue;
        }
        catch (NoSuchMethodException afterPropertiesSetMethod) {
            return fieldValue;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, String> parseToMap(String str, String sep1, String sep2) {
        int index1;
        HashMap<String, String> map = new HashMap<String, String>();
        int offset = 0;
        while ((index1 = str.indexOf(sep1, offset)) >= 0) {
            int index2 = str.indexOf(sep2, index1 + sep1.length());
            if (index2 < 0) {
                index2 = str.length();
            }
            String key = str.substring(offset, index1);
            String value = str.substring(index1 + sep1.length(), index2);
            map.put(key, value);
            offset = index2 + sep2.length();
            if (index2 != str.length()) continue;
            break;
        }
        return map;
    }

    private Object convertToArray(Object value, FieldData field) {
        Object[] fieldValue;
        Class<?> componentType = field.componentType;
        String separator = ",";
        ListValue listValueAn = field.field.getAnnotation(ListValue.class);
        if (listValueAn != null) {
            separator = listValueAn.separator();
        }
        String[] ss = ((String)value).split(separator);
        if (componentType == Integer.TYPE) {
            int[] array = new int[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = (Integer)this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        } else if (componentType == Long.TYPE) {
            long[] array = new long[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = (Long)this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        } else if (componentType == Short.TYPE) {
            short[] array = new short[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = (Short)this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        } else if (componentType == Boolean.TYPE) {
            boolean[] array = new boolean[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = (Boolean)this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        } else if (componentType == Float.TYPE) {
            float[] array = new float[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = ((Float)this.convertToSimple(ss[i], componentType)).floatValue();
            }
            fieldValue = array;
        } else if (componentType == Double.TYPE) {
            double[] array = new double[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                array[i] = (Double)this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        } else {
            Object[] array = (Object[])Array.newInstance(componentType, ss.length);
            for (int i = 0; i < ss.length; ++i) {
                array[i] = this.convertToSimple(ss[i], componentType);
            }
            fieldValue = array;
        }
        return fieldValue;
    }

    private Object newFieldValue(FieldData fd) {
        Class<?> t = fd.field.getType();
        if (Modifier.isAbstract(t.getModifiers())) {
            throw new IllegalArgumentException("type [" + t.getName() + "] is abstract");
        }
        try {
            return t.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("fail to create field value", e);
        }
    }

    private Object newCollectionInstance(FieldData fd) {
        Class<?> t = fd.field.getType();
        if (!(t.isInterface() || t.isAnnotation() || Modifier.isAbstract(t.getModifiers()))) {
            try {
                return t.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("fail to new collection instance", e);
            }
        }
        if (t == Collection.class || List.class.isAssignableFrom(t)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(t)) {
            return new HashSet();
        }
        throw new IllegalStateException("fail to new collection instance");
    }

    private static int nextOffset(String str, int offset) {
        for (int i = offset; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '[' && c != ']' && c != '.') continue;
            return i;
        }
        return -1;
    }

    public void bind(Map<String, Object> map, String prefix, Object obj) {
        Object sub;
        int offset = 0;
        if (prefix.startsWith("[") || prefix.startsWith(".")) {
            offset = 1;
        }
        do {
            char c;
            String key;
            int index;
            if ((index = Binder.nextOffset(prefix, offset)) < 0) {
                index = prefix.length();
            }
            if ((sub = map.get(key = prefix.substring(offset, index))) == null) {
                return;
            }
            if (!(sub instanceof Map)) {
                throw new RuntimeException("invalid path " + prefix + " is not a map");
            }
            for (offset = index + 1; offset < prefix.length() && ((c = prefix.charAt(offset)) == '[' || c == ']' || c == '.'); ++offset) {
            }
        } while (offset != prefix.length());
        Map subMap = (Map)sub;
        if (!subMap.isEmpty()) {
            this.bindSub(subMap, obj, obj.getClass());
        }
    }

    private static class OfValueData {
        Method ofValueMethod;

        private OfValueData() {
        }
    }

    private static class FieldData {
        Field field;
        long fieldOffset;
        boolean simple;
        boolean collection;
        boolean primitive;
        boolean array;
        Class<?> componentType;

        private FieldData() {
        }

        void init() {
            this.fieldOffset = UnsafeUtils.getUnsafe().objectFieldOffset(this.field);
            Class<?> t = this.field.getType();
            this.simple = SIMPLE_TYPES.contains(t);
            this.collection = Collection.class.isAssignableFrom(t);
            this.primitive = PRIMITIVE_TYPES.contains(t);
            this.array = t.isArray();
            if (this.array) {
                this.componentType = t.getComponentType();
            }
        }

        Object get(Object obj) {
            if (this.primitive) {
                try {
                    return this.field.get(obj);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("fail to get field", e);
                }
            }
            return UnsafeUtils.getUnsafe().getObject(obj, this.fieldOffset);
        }

        void set(Object obj, Object value) {
            if (this.primitive) {
                try {
                    this.field.set(obj, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("fail to set field", e);
                }
            } else {
                UnsafeUtils.getUnsafe().putObject(obj, this.fieldOffset, value);
            }
        }
    }

    private static class ClassData {
        FieldData[] fields;

        private ClassData() {
        }
    }
}

