/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config.spring;

import com.xzchaoo.commons.basic.config.Config;
import com.xzchaoo.commons.basic.config.Event;
import com.xzchaoo.commons.basic.config.Listener;
import com.xzchaoo.commons.basic.config.spring.AbstractConfig;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;

public class ConfigListenerContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigListenerContainer.class);
    private final Config config;
    private CopyOnWriteArrayList<AbstractConfig> children = new CopyOnWriteArrayList();

    public ConfigListenerContainer(Config config) {
        this.config = config;
    }

    @PostConstruct
    public void init() {
        this.config.addListener(new Listener(){

            @Override
            public void onEvent(Event event) {
                ConfigListenerContainer.this.refresh();
            }
        });
    }

    public void refreshNow(AbstractConfig c) {
        c.refresh(this.binder());
    }

    public void listener(AbstractConfig c) {
        this.children.add(c);
    }

    private Binder binder() {
        return new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource(this.config.asMap())});
    }

    private void refresh() {
        Binder binder = this.binder();
        for (AbstractConfig c : this.children) {
            try {
                c.refresh(binder);
            }
            catch (Throwable e) {
                LOGGER.error("[config] config refresh error {}", (Object)c.getClass().getSimpleName(), (Object)e);
            }
        }
    }
}

