/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.consistenthash;

import com.xzchaoo.commons.basic.consistenthash.ConsistentHash;
import com.xzchaoo.commons.basic.consistenthash.NodeFunction;
import com.xzchaoo.commons.basic.consistenthash.VNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class DefaultConsistentHash<N>
implements ConsistentHash<N> {
    private final int vNodeCount;
    private final NodeFunction<N> nodeFunction;
    private volatile State state = new State(Collections.emptyList());

    public DefaultConsistentHash(int vNodeCopyCount, NodeFunction<N> nodeFunction) {
        this.vNodeCount = vNodeCopyCount;
        this.nodeFunction = Objects.requireNonNull(nodeFunction);
    }

    public DefaultConsistentHash(int vNodeCount, NodeFunction<N> nodeFunction, List<N> initNodes) {
        this.vNodeCount = vNodeCount;
        this.nodeFunction = Objects.requireNonNull(nodeFunction);
        this.update(initNodes);
    }

    @Override
    public N select(int hash) {
        State state = this.state;
        TreeMap tree = state.tree;
        if (tree.isEmpty()) {
            return null;
        }
        Map.Entry e = tree.ceilingEntry(hash);
        if (e != null) {
            return ((VNode)e.getValue()).node;
        }
        return ((State)state).min.node;
    }

    @Override
    public ConsistentHash.Stat stat() {
        State state = this.state;
        ConsistentHash.Stat stat = new ConsistentHash.Stat();
        stat.setNodeSize(state.nodes.size());
        stat.setVnodeSize(state.tree.size());
        return stat;
    }

    public List<N> getNodes() {
        return this.state.nodes;
    }

    public void update(List<N> nodes) {
        this.state = new State(nodes);
    }

    private int compare(VNode<N> a, VNode<N> b) {
        int r = this.nodeFunction.compare(a.node, b.node);
        if (r != 0) {
            return r;
        }
        return Integer.compare(a.vIndex, b.vIndex);
    }

    private class State {
        private final List<N> nodes;
        private final TreeMap<Integer, VNode<N>> tree = new TreeMap();
        private final VNode<N> min;

        State(List<N> nodes) {
            this.nodes = Collections.unmodifiableList(new ArrayList(nodes));
            for (Object node : nodes) {
                int nodeHash = DefaultConsistentHash.this.nodeFunction.hash(node);
                for (int i = 0; i < DefaultConsistentHash.this.vNodeCount; ++i) {
                    VNode vNode = new VNode(node, nodeHash, i);
                    this.tree.merge(vNode.hash, vNode, (a, b) -> {
                        if (DefaultConsistentHash.this.compare(a, b) < 0) {
                            return a;
                        }
                        return b;
                    });
                }
            }
            Map.Entry first = this.tree.firstEntry();
            this.min = first != null ? first.getValue() : null;
        }
    }
}

