/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.dispose;

import com.xzchaoo.commons.basic.dispose.BooleanDisposable;
import com.xzchaoo.commons.basic.dispose.Disposable;
import com.xzchaoo.commons.basic.dispose.OnceDisposable;
import com.xzchaoo.commons.basic.dispose.SwapDisposable;
import java.util.concurrent.Future;

public final class Disposables {
    public static final Disposable DISPOSED = new Disposed();

    private Disposables() {
    }

    public static boolean isDisposed(Disposable d) {
        return d != null && d.isDisposed();
    }

    public static Disposable fromFuture(Future<?> f) {
        return Disposables.fromFuture(f, true);
    }

    public static Disposable bool() {
        return new BooleanDisposable();
    }

    public static Disposable fromFuture(final Future<?> f, final boolean interrupt) {
        return new Disposable(){

            @Override
            public void dispose() {
                f.cancel(interrupt);
            }

            @Override
            public boolean isDisposed() {
                return f.isCancelled();
            }
        };
    }

    public static Disposable once(Runnable r) {
        return new OnceDisposable(r);
    }

    public static Disposable.Swap swap() {
        return new SwapDisposable();
    }

    private static class Disposed
    implements Disposable {
        private Disposed() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    }
}

