/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.dispose;

import com.xzchaoo.commons.basic.dispose.Disposable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

class ListCompositeDisposable
implements Disposable.Composite {
    volatile boolean disposed;
    private List<Disposable> resources;

    ListCompositeDisposable() {
    }

    ListCompositeDisposable(Disposable ... resources) {
        this.resources = new LinkedList<Disposable>();
        for (Disposable resource : resources) {
            Objects.requireNonNull(resource, "resource is null");
            this.resources.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Disposable> list;
        if (this.disposed) {
            return;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            list = this.resources;
            this.resources = null;
        }
        if (list != null) {
            for (Disposable resource : list) {
                resource.dispose();
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Disposable d) {
        if (this.disposed) {
            d.dispose();
            return false;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return false;
            }
            List<Disposable> list = this.resources;
            if (list == null) {
                this.resources = list = new LinkedList<Disposable>();
            }
            list.add(d);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Disposable d) {
        if (this.disposed) {
            return false;
        }
        ListCompositeDisposable listCompositeDisposable = this;
        synchronized (listCompositeDisposable) {
            if (this.disposed) {
                return false;
            }
            if (this.resources == null || !this.resources.remove(d)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        List<Disposable> r = this.resources;
        return r == null ? 0 : r.size();
    }
}

