/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.dispose;

import com.xzchaoo.commons.basic.dispose.Disposable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class OnceDisposable
extends AtomicReference<Runnable>
implements Disposable {
    OnceDisposable(Runnable runnable) {
        this.lazySet(Objects.requireNonNull(runnable));
    }

    @Override
    public void dispose() {
        Runnable task = this.getAndSet(null);
        if (task != null) {
            task.run();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.get() == null;
    }
}

