/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.drainloop;

import com.xzchaoo.commons.basic.drainloop.DrainLoop;
import org.jctools.queues.MpscChunkedArrayQueue;

public class DrainLoopDemo
extends DrainLoop {
    private final MpscChunkedArrayQueue<Action1> a1q = new MpscChunkedArrayQueue(65536);
    private final MpscChunkedArrayQueue<Action2> a2q = new MpscChunkedArrayQueue(65536);
    private final MpscChunkedArrayQueue<Action3> a3q = new MpscChunkedArrayQueue(65536);
    private final MpscChunkedArrayQueue<Action3Ack> a3Ack = new MpscChunkedArrayQueue(65536);
    private int maxWip = 4;
    private int wip;

    @Override
    protected void drainLoop0() {
        do {
            boolean changed = false;
            changed |= this.consumeA1();
            changed |= this.consumeA2();
            changed |= this.consumeA3();
        } while (changed |= this.consumeA3Ack());
    }

    private boolean consumeA1() {
        Action1 a1;
        boolean changed = false;
        while ((a1 = (Action1)this.a1q.relaxedPoll()) != null) {
            changed = true;
            for (int i = 0; i < 2; ++i) {
                this.a2q.offer((Object)new Action2());
            }
        }
        return changed;
    }

    private boolean consumeA2() {
        Action2 a2;
        boolean changed = false;
        while ((a2 = (Action2)this.a2q.relaxedPoll()) != null) {
            changed = true;
            for (int i = 0; i < 2; ++i) {
                this.a3q.offer((Object)new Action3());
            }
        }
        return changed;
    }

    private boolean consumeA3() {
        while (this.wip < this.maxWip) {
            Action3 a3 = (Action3)this.a3q.relaxedPoll();
            if (a3 == null) {
                return false;
            }
            ++this.wip;
        }
        return false;
    }

    private boolean consumeA3Ack() {
        Action3Ack ack;
        while ((ack = (Action3Ack)this.a3Ack.relaxedPoll()) != null) {
            Action3 a3 = (Action3)this.a3q.relaxedPoll();
            if (a3 != null) continue;
            --this.wip;
        }
        return false;
    }

    public void a3Ack() {
        this.a3Ack.offer((Object)new Action3Ack());
        this.drainLoop();
    }

    private static class Action3Ack {
        private Action3Ack() {
        }
    }

    private static class Action3 {
        private Action3() {
        }
    }

    private static class Action2 {
        private Action2() {
        }
    }

    private static class Action1 {
        private Action1() {
        }
    }
}

