/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.stringdict;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@Beta
public class StringDict {
    private final Map<String, Integer> toIndex = new HashMap<String, Integer>();
    private List<String> stringList;
    private Consumer<String> consumer;

    public StringDict() {
        this.stringList = new ArrayList<String>();
    }

    public StringDict(List<String> stringList) {
        this.stringList = Objects.requireNonNull(stringList);
    }

    public StringDict(Consumer<String> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public void reuse() {
        this.toIndex.clear();
        this.stringList.clear();
    }

    public void reuse(List<String> stringList) {
        this.toIndex.clear();
        this.stringList = stringList;
    }

    public void reuse(Consumer<String> consumer) {
        this.toIndex.clear();
        this.consumer = consumer;
    }

    public int add(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        Integer index = this.toIndex.get(str);
        if (index != null) {
            return index;
        }
        index = this.stringList.size();
        this.toIndex.put(str, index);
        if (this.consumer != null) {
            this.consumer.accept(str);
        } else {
            this.stringList.add(str);
        }
        return index;
    }

    public Map<String, Integer> getToIndex() {
        return this.toIndex;
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    public Consumer<String> getConsumer() {
        return this.consumer;
    }
}

