/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.topology;

import com.xzchaoo.commons.basic.Ack;
import com.xzchaoo.commons.basic.topology.TopologyExecutor;
import com.xzchaoo.commons.basic.topology.TopologyExecutorConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockTopologyExecutor<N extends TopologyExecutor.Node>
implements TopologyExecutor<N> {
    private final Set<N> nodes = Collections.newSetFromMap(new IdentityHashMap());
    private final IdentityHashMap<N, List<N>> edges = new IdentityHashMap();
    private final Lock lock = new ReentrantLock();
    private final Runnable onComplete;
    private final int maxWip;
    private final LinkedList<N> q = new LinkedList();
    private int wip;
    private int ackCount;

    public LockTopologyExecutor(TopologyExecutorConfig config) {
        this.maxWip = config.getMaxWip();
        this.onComplete = config.getOnComplete();
    }

    @Override
    public void add(N from, N to) {
        this.edges.computeIfAbsent(from, ignored -> new ArrayList()).add(to);
        ++((TopologyExecutor.Node)from).out;
        ++((TopologyExecutor.Node)to).in;
        this.nodes.add(from);
        this.nodes.add(to);
    }

    @Override
    public List<N> check() {
        LinkedList<TopologyExecutor.Node> q = new LinkedList<TopologyExecutor.Node>();
        for (TopologyExecutor.Node n : this.nodes) {
            n.inBackup = n.in;
            n.outBackup = n.out;
            if (n.in != 0) continue;
            this.q.offerLast(n);
            q.offerLast(n);
        }
        if (q.isEmpty()) {
            throw new IllegalStateException("roots are empty");
        }
        ArrayList<TopologyExecutor.Node> result = new ArrayList<TopologyExecutor.Node>();
        while (!q.isEmpty()) {
            TopologyExecutor.Node n;
            n = (TopologyExecutor.Node)q.poll();
            result.add(n);
            List<N> toList = this.edges.get(n);
            if (toList == null) continue;
            for (TopologyExecutor.Node to : toList) {
                if (--to.in != 0) continue;
                q.offerLast(to);
            }
        }
        if (result.size() != this.nodes.size()) {
            throw new IllegalStateException("Not a DAG");
        }
        for (TopologyExecutor.Node n : this.nodes) {
            n.in = n.inBackup;
            n.out = n.outBackup;
        }
        return result;
    }

    @Override
    public void execute() {
        this.drainLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ack(N n) {
        this.lock.lock();
        try {
            --this.wip;
            List<N> toList = this.edges.get(n);
            if (toList != null) {
                for (TopologyExecutor.Node to : toList) {
                    if (--to.in != 0) continue;
                    this.q.offerLast(to);
                }
            }
            this.drainLoop();
            if (++this.ackCount == this.nodes.size() && this.onComplete != null) {
                this.onComplete.run();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void drainLoop() {
        this.lock.lock();
        try {
            while (!(this.maxWip > 0 && this.wip >= this.maxWip || this.q.isEmpty())) {
                ++this.wip;
                TopologyExecutor.Node n = (TopologyExecutor.Node)this.q.pollFirst();
                this.execute(n);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void execute(N n) {
        ((TopologyExecutor.Node)n).execute(Ack.once(() -> this.ack(n)));
    }
}

