/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.topology;

import com.xzchaoo.commons.basic.Ack;
import com.xzchaoo.commons.basic.topology.NodeFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;

public class TopologyGraph<N> {
    private final NodeFunction<N> nf;
    private final Map<String, GNode<N>> nodes = new HashMap<String, GNode<N>>();
    private final Map<String, List<String>> edges = new HashMap<String, List<String>>();
    private final Semaphore semaphore;
    private int ackCount;

    public TopologyGraph(NodeFunction<N> nf, int maxWip) {
        this.nf = nf;
        this.semaphore = new Semaphore(maxWip);
    }

    public void add(N from, N to) {
        String fromId = this.nf.id(from);
        String toId = this.nf.id(to);
        GNode fromNode = this.nodes.computeIfAbsent(fromId, ignored -> new GNode<Object>(fromId, from));
        GNode toNode = this.nodes.computeIfAbsent(toId, ignored -> new GNode<Object>(toId, to));
        ++fromNode.out;
        ++toNode.in;
        this.edges.computeIfAbsent(fromId, ignored -> new ArrayList()).add(toId);
    }

    public synchronized CountDownLatch consume(BiConsumer<N, Ack> consumer) {
        CountDownLatch cdl = new CountDownLatch(this.nodes.size());
        ArrayList<GNode<N>> roots = new ArrayList<GNode<N>>();
        for (GNode<Object> gn : this.nodes.values()) {
            if (gn.in != 0) continue;
            roots.add(gn);
        }
        for (GNode<Object> gn : roots) {
            this.consume(gn, consumer, cdl);
        }
        return cdl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ack(GNode<N> gn, BiConsumer<N, Ack> consumer, CountDownLatch cdl) {
        System.out.println("ack");
        this.semaphore.release();
        cdl.countDown();
        TopologyGraph topologyGraph = this;
        synchronized (topologyGraph) {
            List<String> toList;
            if (++this.ackCount == this.nodes.size()) {
                System.out.println("done");
            }
            if ((toList = this.edges.get(gn.id)) != null) {
                for (String toId : toList) {
                    GNode<N> toNode = this.nodes.get(toId);
                    if (--toNode.in != 0) continue;
                    this.consume(toNode, consumer, cdl);
                }
            }
        }
    }

    private void consume(GNode<N> gn, BiConsumer<N, Ack> consumer, CountDownLatch cdl) {
        System.out.println("acquire");
        this.semaphore.acquireUninterruptibly();
        consumer.accept(gn.n, () -> this.ack(gn, consumer, cdl));
    }

    static class GNode<N> {
        final String id;
        final N n;
        int in;
        int out;

        public GNode(String id, N n) {
            this.id = id;
            this.n = n;
        }
    }
}

