package com.xzchaoo.commons.basic.concurrent;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.annotation.concurrent.NotThreadSafe;
import java.util.Random;

/**
 * 退避, 非线程安全
 *
 * @author xzchaoo
 * <p> created at 2021/2/13
 */
@Getter
@ToString
@Setter
@NotThreadSafe
public class Backoff {
    private final Random random = new Random();
    private long init;
    private long max;
    private double multiplier;
    private double jitter;
    private long next;

    public Backoff(long init, long max) {
        this(init, max, 1.6, 0.2);
    }

    public Backoff(long init, long max, double multiplier, double jitter) {
        this.init = init;
        this.max = max;
        this.multiplier = multiplier;
        this.jitter = jitter;
        this.next = init;
    }

    public long next() {
        long current = next;
        next = Math.min((long) (next * multiplier), max);
        double halfGap = jitter * current;
        return current + (long) (random.nextDouble() * halfGap * 2 - halfGap);
    }

    public void reset() {
        this.next = init;
    }

    public void configure(long init, long max, double multiplier, double jitter) {
        this.init = init;
        this.max = max;
        this.multiplier = multiplier;
        this.jitter = jitter;
        this.next = init;
    }
}
