package com.xzchaoo.commons.basic.concurrent;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import com.xzchaoo.commons.basic.dispose.Disposable;

/**
 * <p>created at 2020-08-24
 *
 * @author xiangfeng.xzc
 */
public final class SchedulerUtils {
    private SchedulerUtils() {
    }

    public static ScheduledFuture<?> scheduleAtFixedRateAligned(
            ScheduledExecutorService s, //
            Runnable cmd, //
            long period, //
            TimeUnit unit) {

        return scheduleAtFixedRateAligned(s, cmd, period, 0L, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRateAligned(
            ScheduledExecutorService s, //
            Runnable cmd, //
            long period, //
            long offset, //
            TimeUnit unit) {

        long periodMs = unit.toMillis(period);
        long now = System.currentTimeMillis();
        long nextTime = now / periodMs * periodMs + periodMs + unit.toMillis(offset);
        long delay = nextTime - now;
        return s.scheduleAtFixedRate(cmd, delay, periodMs, TimeUnit.MILLISECONDS);
    }

    public static Disposable dynamic(ScheduledExecutorService scheduler, //
            Runnable task, //
            Duration initDelay, //
            Supplier<Duration> delayProvider) { //
        return DynamicScheduledExecutorService.wrap(scheduler)
                .dynamic(task, initDelay, delayProvider);
    }
}
