package com.xzchaoo.commons.basic.config;

import java.util.List;
import java.util.Map;

/**
 * TODO 能否将spring的binder功能移植过来?
 * <p>created at 2020-08-07
 *
 * @author xiangfeng.xzc
 */
public interface Config {
    Map<String, String> asMap();

    double getDouble(String key, double defaultValue);

    Double getDouble(String key);

    int getInt(String key, int defaultValue);

    Integer getInteger(String key);

    long getLong(String key, long defaultValue);

    Long getLong(String key);

    String getString(String key, String defaultValue);

    String getString(String key);

    boolean getBoolean(String key, boolean defaultValue);

    Boolean getBoolean(String key);

    void addListener(Listener listener);

    Manager manager();

    /**
     * 这个name有用吗?
     */
    String name();

    void removeListener(Listener listener);

    void lockAndListen(Runnable runnable, Listener listener);

    interface Composite extends Config {
        /**
         * Get children configs
         *
         * @return children configs
         */
        List<Config> children();
    }
}
