package com.xzchaoo.commons.basic.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import static java.util.Collections.emptyMap;

/**
 * <p>created at 2020-08-07
 *
 * @author xiangfeng.xzc
 */
@SuppressWarnings("WeakerAccess")
public class MapConfig extends AbstractConfig {
    private volatile Map<String, String> map = emptyMap();

    public MapConfig(Manager manager) {
        super(manager);
        internalSetMap(emptyMap(), false);
    }

    public MapConfig(Manager manager, Map<String, String> map) {
        super(manager);
        internalSetMap(map, false);
    }

    public MapConfig(Manager manager, Properties p) {
        super(manager);
        internalSetMap(p, false);
    }

    @Override
    public Map<String, String> asMap() {
        return map;
    }

    @Override
    public String getString(String key) {
        return map.get(key);
    }

    protected void internalSetMap(Properties p, boolean fire) {
        internalSetMap(Utils.propertiesToMap(p), fire);
    }

    protected void internalSetMap(Map<String, String> map, boolean fire) {
        lock();
        try {
            this.map = Collections.unmodifiableMap(new HashMap<>(map));
            if (fire) {
                fireChange();
            }
        } finally {
            unlock();
        }
    }
}
