package com.xzchaoo.commons.basic.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * <p>created at 2020-08-07
 *
 * @author xiangfeng.xzc
 */
final class Utils {
    static Map<String, String> propertiesToMap(Properties p) {
        Map<String, String> map = new HashMap<>();
        for (String key : p.stringPropertyNames()) {
            map.put(key, p.getProperty(key));
        }
        return map;
    }

    static MapConfig fromPropertiesFile(Manager manager,File file) throws IOException {
        return fromPropertiesStream(manager,Files.newInputStream(file.toPath()));
    }

    static MapConfig fromPropertiesStream(Manager manager,InputStream inputStream)
        throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        try {
            Properties p = new Properties();
            p.load(inputStream);
            return new MapConfig(manager,p);
        } finally {
            inputStream.close();
        }
    }
}
