package com.xzchaoo.commons.basic.config.bind;

import lombok.ToString;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author xzchaoo
 * <p> created at 2021/12/18
 */
@ToString
public class Path {
    private final Token[] tokens;

    private Path(Token[] tokens) {
        this.tokens = tokens;
    }

    public static Path parse(String str) {
        int tokenBegin = 0;
        boolean start = false;
        List<Token> tokens = new ArrayList<>();
        for (int i = 0; i < str.length(); i++) {
            switch (str.charAt(i)) {
                case '[':
                    if (start) {
                        throw new IllegalStateException("already start");
                    }
                    if (tokenBegin != i) {
                        tokens.add(new Token(str, tokenBegin, i));
                    }
                    start = true;
                    tokenBegin = i + 1;
                    break;
                case ']': {
                    if (!start) {
                        throw new IllegalStateException("not started");
                    }
                    tokens.add(new Token(str, tokenBegin, i));
                    start = false;
                    tokenBegin = i + 1;
                }
                break;
                case '.':
                    if (start) {
                        throw new IllegalStateException("already start");
                    }
                    if (tokenBegin != i) {
                        tokens.add(new Token(str, tokenBegin, i));
                    }
                    tokenBegin = i + 1;
                    break;
                default:
                    break;
            }
        }
        if (start) {
            throw new IllegalStateException("need stop");
        }
        if (str.charAt(str.length() - 1) != ']') {
            tokens.add(new Token(str, tokenBegin, str.length()));
        }
        return new Path(tokens.toArray(new Token[tokens.size()]));
    }

    @ToString
    public static class Token {
        final String str;
        final int begin;
        final int end;
        String value;

        Token(String str, int begin, int end) {
            this.str = str;
            this.begin = begin;
            this.end = end;
            get();
        }

        String get() {
            if (value != null) {
                return value;
            }
            value = str.substring(begin, end);
            return value;
        }
    }
}
