package com.xzchaoo.commons.basic.config.spring;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.bind.Binder;

import javax.annotation.PostConstruct;

/**
 * @author xzchaoo
 * <p> created at 2022/2/25
 */
public abstract class AbstractConfig {
    @Autowired
    private ConfigListenerContainer appConfigContainer;

    @PostConstruct
    public void init() {
        appConfigContainer.listener(this);
        appConfigContainer.refreshNow(this);
    }

    protected abstract void refresh(Binder binder);
}
