package com.xzchaoo.commons.basic.config.spring;

import com.xzchaoo.commons.basic.config.Config;
import com.xzchaoo.commons.basic.config.Event;
import com.xzchaoo.commons.basic.config.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;

import javax.annotation.PostConstruct;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * @author xzchaoo
 * <p> created at 2022/2/25
 */
public class ConfigListenerContainer  {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigListenerContainer.class);

    private final Config config;
    private CopyOnWriteArrayList<AbstractConfig> children = new CopyOnWriteArrayList<>();

    public ConfigListenerContainer(Config config) {
        this.config = config;
    }

    @PostConstruct
    public void init() {
        config.addListener(new Listener() {
            @Override
            public void onEvent(Event event) {
                refresh();
            }
        });
    }

    public void refreshNow(AbstractConfig c) {
        c.refresh(binder());
    }

    public void listener(AbstractConfig c) {
        children.add(c);
    }

    private Binder binder() {
        return new Binder(new MapConfigurationPropertySource(config.asMap()));
    }

    private void refresh() {
        Binder binder = binder();
        for (AbstractConfig c : children) {
            try {
                c.refresh(binder);
            } catch (Throwable e) {
                LOGGER.error("[config] config refresh error {}", c.getClass().getSimpleName(), e);
            }
        }
    }
}
