package com.xzchaoo.commons.basic.consistenthash;

import com.google.common.hash.Hashing;

/**
 * created at 2020/7/26
 *
 * @author xzchaoo
 */
class VNode<N> {
    final N   node;
    final int nodeHash;
    final int vIndex;
    final int hash;

    VNode(N node, int nodeHash, int vIndex) {
        this.node = node;
        this.nodeHash = nodeHash;
        this.vIndex = vIndex;
        // mm32 更加离散 因此用它
        this.hash = Hashing.murmur3_32() //
            .newHasher() //
            .putInt(nodeHash) //
            .putInt(vIndex) //
            .hash() //
            .asInt();//
    }
}
