package com.xzchaoo.commons.basic.dispose;

import java.util.concurrent.Future;

/**
 * <p>created at 2020-08-04
 *
 * @author xiangfeng.xzc
 */
@SuppressWarnings("WeakerAccess")
public final class Disposables {
    public static final Disposable DISPOSED = new Disposed();

    private Disposables() {
    }

    public static boolean isDisposed(Disposable d) {
        return d != null && d.isDisposed();
    }

    public static Disposable fromFuture(Future<?> f) {
        return fromFuture(f, true);
    }

    public static Disposable bool() {
        return new BooleanDisposable();
    }

    public static Disposable fromFuture(Future<?> f, boolean interrupt) {
        return new Disposable() {
            @Override
            public void dispose() {
                f.cancel(interrupt);
            }

            @Override
            public boolean isDisposed() {
                return f.isCancelled();
            }
        };
    }

    public static Disposable once(Runnable r) {
        return new OnceDisposable(r);
    }

    /**
     * Returns a swap-disposable
     *
     * @return swap disposable
     */
    public static Disposable.Swap swap() {
        return new SwapDisposable();
    }

    private static class Disposed implements Disposable {
        @Override
        public void dispose() {

        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    }
}
