package com.xzchaoo.commons.basic.dispose;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

/**
 * <p>created at 2020-08-04
 *
 * @author xiangfeng.xzc
 */
class OnceDisposable extends AtomicReference<Runnable> implements Disposable {
    OnceDisposable(Runnable runnable) {
        lazySet(Objects.requireNonNull(runnable));
    }

    @Override
    public void dispose() {
        Runnable task = getAndSet(null);
        if (task != null) {
            task.run();
        }
    }

    @Override
    public boolean isDisposed() {
        return get() == null;
    }
}
