package com.xzchaoo.commons.basic.dispose;

import java.util.concurrent.atomic.AtomicReference;

/**
 * <p>created at 2020-08-04
 *
 * @author xiangfeng.xzc
 */
class SwapDisposable extends AtomicReference<Disposable>
    implements Disposable.Swap {

    @Override
    public void dispose() {
        Disposable d = get();
        if (d != null && d != Disposables.DISPOSED) {
            lazySet(Disposables.DISPOSED);
            d.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return Disposables.isDisposed(get());
    }

    @Override
    public void update(Disposable d) {
        update0(d, true);
    }

    @Override
    public void replace(Disposable d) {
        update0(d, false);
    }

    private void update0(Disposable d, boolean disposePrev) {
        for (; ; ) {
            Disposable old = get();
            if (old == d) {
                return;
            }
            if (old != null && old.isDisposed()) {
                if (old != Disposables.DISPOSED) {
                    lazySet(Disposables.DISPOSED);
                }
                if (d != null) {
                    d.dispose();
                }
                return;
            }
            if (compareAndSet(old, d)) {
                if (disposePrev && old != null) {
                    old.dispose();
                }
                break;
            }
        }
    }
}
