package com.xzchaoo.commons.basic.drainloop;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * DrainLoop 的特点是
 * <ul>
 * <li>无额外线程代价</li>
 * <li>无锁</li>
 * <li>串行化</li>
 * <li>非立即出结果</li>
 * </ul>
 * <p>
 * 什么时候使用 DrainLoop ?
 * <ul>
 * <li>场景满足DrainLoop的特点</li>
 * <li>追求性能极致</li>
 * <li></li>
 * </ul>
 * <p>created at 2020-08-11
 *
 * @author xiangfeng.xzc
 */
public abstract class DrainLoop {
    private final AtomicInteger drainLoopWip = new AtomicInteger();

    protected final void drainLoop() {
        if (drainLoopWip.getAndIncrement() != 0) {
            return;
        }
        int delta = drainLoopWip.get();
        do {
            drainLoop0();
            delta = drainLoopWip.addAndGet(-delta);
        } while (delta != 0);
    }
    
    protected abstract void drainLoop0();
}
