package com.xzchaoo.commons.basic.drainloop;

import org.jctools.queues.MpscChunkedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Consumer;

/**
 * @author xzchaoo
 * <p> created at 2020/9/23
 */
public class MpscDrainLoop<T> extends DrainLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpscDrainLoop.class);

    private final MpscChunkedArrayQueue<T> q;
    private final Consumer<T> consumer;

    public MpscDrainLoop(int queueSize, Consumer<T> consumer) {
        this.q = new MpscChunkedArrayQueue<>(queueSize);
        this.consumer = consumer;
    }

    public boolean add(T t) {
        if (!q.add(t)) {
            return false;
        }
        drainLoop();
        return true;
    }

    @Override
    protected void drainLoop0() {
        for (; ; ) {
            T t = q.relaxedPoll();
            if (t == null) {
                break;
            }
            try {
                consumer.accept(t);
            } catch (Throwable e) {
                LOGGER.error("Exception caught when consume element", e);
            }
        }
    }
}
