package com.xzchaoo.commons.basic.json;

import java.util.Map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * @author xzchaoo
 */
public class JsonNodeUtils {
  private JsonNodeUtils() {
  }

  public static ObjectNode merge(ObjectNode a, ObjectNode b) {
    ObjectNode cp = a.deepCopy();
    mergeTo(cp, b);
    return cp;
  }

  /**
   * 合并 b 到 a 里, 会对 b 进行深度复制, 因此 b 在返回之后依旧可以使用
   *
   * @param to
   * @param o
   * @return
   */
  public static void mergeTo(ObjectNode to, ObjectNode o) {
    if (o == null || o.isEmpty() || o.isMissingNode()) {
      return;
    }
    for (Map.Entry<String, JsonNode> e : o.properties()) {
      JsonNode exist = to.get(e.getKey());

      if (exist == null) {
        to.set(e.getKey(), e.getValue().deepCopy());
      } else {
        JsonNode v = e.getValue();
        if (exist.isObject() && !v.isObject()) {
          throw new IllegalArgumentException("incompatible types");
        }
        if (exist.isArray() && !v.isArray()) {
          throw new IllegalArgumentException("incompatible types");
        }
        if (exist.isObject()) {
          mergeTo((ObjectNode) exist, (ObjectNode) v);
        } else {
          to.set(e.getKey(), e.getValue().deepCopy());
        }
      }
    }
  }
}
