package com.xzchaoo.commons.basic.lang;

/**
 * @author xzchaoo
 * <p> created at 2021/4/26
 */
public final class TimeService {
    private static volatile long interval = Long.getLong("TimeService.interval", 100L);
    private static volatile long millTime;

    static {
        millTime = System.currentTimeMillis();
        Thread t = new Thread(new Update(), "TimeService");
        t.setDaemon(true);
        t.start();
    }

    public static long getMillTime() {
        return millTime;
    }

    public static long getInterval() {
        return interval;
    }

    public static void setInterval(long interval) {
        TimeService.interval = interval;
    }

    private TimeService() {
    }

    private static class Update implements Runnable {
        @Override
        public void run() {
            Thread t = Thread.currentThread();
            while (!t.isInterrupted()) {
                millTime = System.currentTimeMillis();
                try {
                    // noinspection BusyWait
                    Thread.sleep(interval);
                } catch (InterruptedException e) {
                    t.interrupt();
                    break;
                }
            }
        }
    }
}
