package com.xzchaoo.commons.basic.lock;

import java.util.concurrent.atomic.AtomicLong;

/**
 * <p>created at 2020-08-11
 *
 * @author xiangfeng.xzc
 */
public class SpinLock {
    private final AtomicLong current = new AtomicLong();

    /**
     * Spin until the lock is acquired. Returns the state(thread id) for later call to {@link #unlock(long)}.
     *
     * @return lock state for {@link #unlock(long)}
     */
    public long lock() {
        long id = Thread.currentThread().getId();
        for (; ; ) {
            long current = this.current.get();
            if (current == id) {
                throw new IllegalStateException("Reentrance is not supported");
            }
            if (current == 0 && this.current.compareAndSet(0, id)) {
                break;
            }
        }
        return id;
    }

    /**
     * @param state state returned by {@link #lock()}
     * @deprecated use {@link #unlock(long)}
     */
    @Deprecated
    public void release(long state) {
        unlock(state);
    }

    public void unlock(long state) {
        if (!current.compareAndSet(state, 0)) {
            throw new IllegalStateException("SpinLock is not held by " + state);
        }
    }

}
