package com.xzchaoo.commons.basic.objectconfig;

import java.util.concurrent.CopyOnWriteArrayList;

import lombok.extern.slf4j.Slf4j;

/**
 * Abstract base config for {@link Config}.
 *
 * @author xzchaoo
 */
@Slf4j
public abstract class AbstractConfig implements Config {
  private final CopyOnWriteArrayList<Runnable> listeners = new CopyOnWriteArrayList<>();

  protected void fire() {
    for (Runnable listener : listeners) {
      try {
        listener.run();
      } catch (Exception e) {
        log.error("listener error", e);
      }
    }
  }

  @Override
  public Runnable listen(Runnable listener) {
    listeners.add(listener);
    return () -> listeners.remove(listener);
  }
}
