package com.xzchaoo.commons.basic.objectconfig;

import java.util.function.Supplier;

/**
 * @author xzchaoo
 */
public interface BizConfigHolder<T> extends Supplier<T> {
  /**
   * Get the biz pojo.
   *
   * @return
   */
  @Override
  T get();

  /**
   * After unbinding, the get method can still be called, but its value will not change.
   */
  void unbind();

  /**
   * Listening for changes
   *
   * @param listener
   * @return remove listener
   */
  Runnable listen(Runnable listener);
}
