package com.xzchaoo.commons.basic.objectconfig;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import lombok.extern.slf4j.Slf4j;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xzchaoo.commons.basic.json.JsonNodeUtils;

/**
 * @author xzchaoo
 */
@Slf4j
class Composite extends AbstractConfig {
  private final    List<Config> configs;
  private volatile ObjectNode   merged = ConfigFactory.JSON_OM.createObjectNode();
  private final    Lock         lock   = new ReentrantLock();
  //private final    List<Runnable>                 removeListeners;

  Composite(List<Config> configs) {
    this.configs = Objects.requireNonNull(configs);
    for (Config config : configs) {
      config.listen(this::update);
    }
    update();
    //this.removeListeners = configs.stream().map(x -> x.listen(this::update)).collect(Collectors.toList());
  }

  private void update() {
    lock.lock();
    try {
      ObjectNode merged = ConfigFactory.JSON_OM.createObjectNode();
      for (Config cfg : configs) {
        try {
          JsonNodeUtils.mergeTo(merged, cfg.get());
        } catch (Exception e) {
          log.error("merge config error", e);
        }
      }
      this.merged = merged;
      fire();
    } finally {
      lock.unlock();
    }
  }

  @Override
  public ObjectNode get() {
    return merged;
  }
}
