package com.xzchaoo.commons.basic.objectconfig;

import java.util.function.Consumer;

import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * The underlying configuration of a Config can be expressed through ObjectNode.
 *
 * @author xzchaoo
 */
public interface Config {
  /**
   * Get the underlying ObjectNode. Users are not allowed to modify the return value.
   *
   * @return
   */
  ObjectNode get();

  /**
   * Listen to changes in Config and call the returned Runnable to remove the listener.
   *
   * @param listener
   * @return remove listener
   */
  default Runnable listen(Runnable listener) {
    return () -> {};
  }

  default Runnable listen(Consumer<Config> listener) {
    return listen(() -> listener.accept(this));
  }
}
