package com.xzchaoo.commons.basic.objectconfig;

import java.util.Objects;

import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * @author xzchaoo
 */
public class ReplaceableConfig extends AbstractConfig {
  private volatile ObjectNode node;

  public ReplaceableConfig(ObjectNode node) {
    this.node = Objects.requireNonNull(node);
  }

  @Override
  public ObjectNode get() {
    return node;
  }

  public void set(ObjectNode node) {
    this.node = Objects.requireNonNull(node);
    super.fire();
  }
}
