package com.xzchaoo.commons.basic.topology;

import java.util.List;

import com.xzchaoo.commons.basic.Ack;

/**
 * <p>created at 2020-08-11
 *
 * @param <N> node type
 * @author xiangfeng.xzc
 * @since 1.0.3
 */
public interface TopologyExecutor<N extends TopologyExecutor.Node> {
    /**
     * Add an edge: 'from -&gt; to'. Means that 'to' can only be executed after
     * 'from'.
     *
     * @param from from
     * @param to   to
     */
    void add(N from, N to);

    /**
     * check DAG
     *
     * @return topology order result
     */
    List<N> check();

    void execute();

    abstract class Node {
        int in;
        int out;

        int inBackup;
        int outBackup;

        public abstract void execute(Ack ack);
    }
}
