package com.xzchaoo.commons.basic.unsafe;

import sun.misc.Unsafe;

import java.lang.reflect.Field;

/**
 * @author xzchaoo
 * <p> created at 2021/12/18
 */
public class UnsafeUtils {
    private static volatile Unsafe INSTANCE;

    public static Unsafe getUnsafe() {
        if (INSTANCE == null) {
            synchronized (UnsafeUtils.class) {
                if (INSTANCE == null) {
                    try {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        INSTANCE = (Unsafe) f.get(null);
                    } catch (Throwable e) {
                        throw new RuntimeException("get unsafe error", e);
                    }
                }
            }
        }
        return INSTANCE;
    }

    public static char[] getStringChars(String str) {
        try {
            long offset = getUnsafe().objectFieldOffset(String.class.getDeclaredField("value"));
            return (char[]) getUnsafe().getObject(str, offset);
        } catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}
