/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.collection;

import java.util.AbstractList;
import java.util.Arrays;
import lombok.Generated;

public class ArrayListWrapper<E>
extends AbstractList<E> {
    private Object[] array;
    private int offset;
    private int size;

    public ArrayListWrapper(int length) {
        this(new Object[length]);
    }

    public ArrayListWrapper(Object[] array) {
        this(array, 0, array.length);
    }

    public ArrayListWrapper(Object[] array, int offset, int size) {
        if (offset + size > array.length) {
            throw new IllegalArgumentException("offset + size > array.length");
        }
        this.array = array;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public E get(int index) {
        return (E)this.array[this.offset + index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, this.offset, this.offset + this.size, null);
    }

    public void deepClear() {
        Arrays.fill(this.array, null);
    }

    @Generated
    public Object[] getArray() {
        return this.array;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public void setArray(Object[] array) {
        this.array = array;
    }

    @Generated
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Generated
    public void setSize(int size) {
        this.size = size;
    }
}

