/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AsyncThrottleSerializingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncThrottleSerializingTask.class);
    private final Executor executor;
    private final Runnable task;
    private final AtomicInteger wip = new AtomicInteger();

    public AsyncThrottleSerializingTask(Runnable task, Executor executor) {
        this.task = Objects.requireNonNull(task);
        this.executor = Objects.requireNonNull(executor);
    }

    public AsyncThrottleSerializingTask(Runnable task, ScheduledExecutorService executor, Duration delay) {
        this.task = Objects.requireNonNull(task);
        Objects.requireNonNull(executor);
        long mills = delay.toMillis();
        this.executor = t -> executor.schedule(t, mills, TimeUnit.MILLISECONDS);
    }

    public void trigger() {
        if (this.wip.getAndIncrement() == 0) {
            this.executor.execute(this::run0);
        }
    }

    private void run0() {
        int delta = this.wip.get();
        do {
            try {
                this.task.run();
            }
            catch (Throwable e) {
                LOGGER.error("Exception when executing task {}", (Object)this.task, (Object)e);
            }
        } while ((delta = this.wip.addAndGet(-delta)) != 0);
    }
}

