/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.Random;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
public class Backoff {
    private final Random random = new Random();
    private long init;
    private long max;
    private double multiplier;
    private double jitter;
    private long next;

    public Backoff(long init, long max) {
        this(init, max, 1.6, 0.2);
    }

    public Backoff(long init, long max, double multiplier, double jitter) {
        this.init = init;
        this.max = max;
        this.multiplier = multiplier;
        this.jitter = jitter;
        this.next = init;
    }

    public long next() {
        long current = this.next;
        this.next = Math.min((long)((double)this.next * this.multiplier), this.max);
        double halfGap = this.jitter * (double)current;
        return current + (long)(this.random.nextDouble() * halfGap * 2.0 - halfGap);
    }

    public void reset() {
        this.next = this.init;
    }

    public void configure(long init, long max, double multiplier, double jitter) {
        this.init = init;
        this.max = max;
        this.multiplier = multiplier;
        this.jitter = jitter;
        this.next = init;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public long getInit() {
        return this.init;
    }

    @Generated
    public long getMax() {
        return this.max;
    }

    @Generated
    public double getMultiplier() {
        return this.multiplier;
    }

    @Generated
    public double getJitter() {
        return this.jitter;
    }

    @Generated
    public long getNext() {
        return this.next;
    }

    @Generated
    public String toString() {
        return "Backoff(random=" + this.getRandom() + ", init=" + this.getInit() + ", max=" + this.getMax() + ", multiplier=" + this.getMultiplier() + ", jitter=" + this.getJitter() + ", next=" + this.getNext() + ")";
    }

    @Generated
    public void setInit(long init) {
        this.init = init;
    }

    @Generated
    public void setMax(long max) {
        this.max = max;
    }

    @Generated
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    @Generated
    public void setJitter(double jitter) {
        this.jitter = jitter;
    }

    @Generated
    public void setNext(long next) {
        this.next = next;
    }
}

