/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;

public class DynamicSemaphore {
    private final Lock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();
    private int max;
    private int used;
    private int waiting;

    public DynamicSemaphore(int max) {
        this.max = max;
    }

    public void setMax(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException("setMax " + max);
        }
        this.lock.lock();
        try {
            int oldMax = this.max;
            this.max = max;
            if (this.waiting > 0 && max > oldMax) {
                this.available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void acquire(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("acquire " + n);
        }
        this.lock.lock();
        try {
            while (this.used + n > this.max) {
                ++this.waiting;
                try {
                    this.available.awaitUninterruptibly();
                }
                finally {
                    --this.waiting;
                }
            }
            this.used += n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void acquire() {
        this.acquire(1);
    }

    public void acquireInterruptibly() throws InterruptedException {
        this.acquireInterruptibly(1);
    }

    public void acquireInterruptibly(int n) throws InterruptedException {
        if (n <= 0) {
            throw new IllegalArgumentException("acquire " + n);
        }
        this.lock.lockInterruptibly();
        try {
            while (this.used + n > this.max) {
                ++this.waiting;
                try {
                    this.available.await();
                }
                finally {
                    --this.waiting;
                }
            }
            this.used += n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int n, long timeout, TimeUnit unit) throws InterruptedException {
        if (n <= 0) {
            throw new IllegalArgumentException("acquire " + n);
        }
        if (timeout <= 0L) {
            return this.tryAcquire(n);
        }
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (this.used + n > this.max) {
                ++this.waiting;
                try {
                    if ((nanos = this.available.awaitNanos(nanos)) > 0L) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    --this.waiting;
                }
            }
            this.used += n;
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public boolean tryAcquire(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("acquire " + n);
        }
        this.lock.lock();
        try {
            if (this.used + n <= this.max) {
                this.used += n;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("release " + n);
        }
        this.lock.lock();
        try {
            this.used -= n;
            if (this.waiting > 0 && this.used < this.max) {
                int signalN = Math.min(this.waiting, this.max - this.used);
                if (signalN == this.waiting) {
                    this.available.signalAll();
                } else {
                    for (int i = 0; i < signalN; ++i) {
                        this.available.signal();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void release() {
        this.release(1);
    }

    public Stat stat() {
        Stat stat = new Stat();
        this.lock.lock();
        try {
            stat.max = this.max;
            stat.used = this.used;
            stat.waiting = this.waiting;
        }
        finally {
            this.lock.unlock();
        }
        return stat;
    }

    public static class Stat {
        private int max;
        private int used;
        private int waiting;

        @Generated
        public int getMax() {
            return this.max;
        }

        @Generated
        public int getUsed() {
            return this.used;
        }

        @Generated
        public int getWaiting() {
            return this.waiting;
        }

        @Generated
        public String toString() {
            return "DynamicSemaphore.Stat(max=" + this.getMax() + ", used=" + this.getUsed() + ", waiting=" + this.getWaiting() + ")";
        }
    }
}

