/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;

public class LiteCondition {
    private final AtomicBoolean needNotify = new AtomicBoolean();
    private final Lock lock;
    private final Condition condition;

    public LiteCondition() {
        this(new ReentrantLock());
    }

    public LiteCondition(Lock lock) {
        this.lock = lock;
        this.condition = lock.newCondition();
    }

    public static LiteCondition create(Lock lock) {
        return new LiteCondition(lock);
    }

    public void wait(BooleanSupplier b) {
        this.lock.lock();
        try {
            while (true) {
                this.needNotify.set(true);
                if (b.getAsBoolean()) {
                    break;
                }
                this.condition.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitNanos(BooleanSupplier b, long nanos) throws InterruptedException {
        this.lock.lock();
        try {
            do {
                this.needNotify.set(true);
                if (!b.getAsBoolean()) continue;
                long l = nanos;
                return l;
            } while ((nanos = this.condition.awaitNanos(nanos)) > 0L);
            long l = nanos;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void signal() {
        if (this.needNotify.get() && this.needNotify.compareAndSet(true, false)) {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void signalAll() {
        if (this.needNotify.get() && this.needNotify.compareAndSet(true, false)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

