/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;

public class OneThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private boolean done;

    public OneThreadFactory(String name) {
        this(name, false);
    }

    public OneThreadFactory(String name, boolean daemon) {
        this.name = Objects.requireNonNull(name);
        this.daemon = daemon;
    }

    @Override
    public synchronized Thread newThread(Runnable r) {
        if (this.done) {
            throw new IllegalStateException("thread has been created");
        }
        this.done = true;
        Thread t = new Thread(r, this.name);
        t.setDaemon(this.daemon);
        return t;
    }
}

