/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SerializingExecutor
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializingExecutor.class);
    private static final int CHUNK_SIZE = 4096;
    private final Executor executor;
    private final MessagePassingQueue<Runnable> queue;
    private final AtomicInteger wip = new AtomicInteger(0);

    public SerializingExecutor(Executor executor) {
        this(executor, 4096, 0);
    }

    public SerializingExecutor(Executor executor, int chunkSize, int maxCapacity) {
        this.executor = Objects.requireNonNull(executor);
        this.queue = maxCapacity == 0 ? new MpscUnboundedArrayQueue(chunkSize) : new MpscChunkedArrayQueue(chunkSize, maxCapacity);
    }

    @Override
    public void execute(Runnable task) {
        if (!this.queue.offer((Object)Objects.requireNonNull(task, "task is null"))) {
            throw new RejectedExecutionException("Task " + task + " rejected from " + this);
        }
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        try {
            this.executor.execute(this::drain);
        }
        catch (Throwable e) {
            this.drain();
            LOGGER.error("Exception caught when schedule drain", e);
        }
    }

    private void drain() {
        int delta = this.wip.get();
        while (true) {
            Runnable r;
            if ((r = (Runnable)this.queue.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    LOGGER.error("Exception while executing runnable " + r, e);
                }
                continue;
            }
            if ((delta = this.wip.addAndGet(-delta)) == 0) break;
        }
    }
}

