/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicLong ai = new AtomicLong();
    private final boolean daemon;

    public SimpleThreadFactory(String prefix) {
        this(prefix, true);
    }

    public SimpleThreadFactory(String prefix, boolean daemon) {
        this.prefix = Objects.requireNonNull(prefix);
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable r) {
        String name = this.prefix + "-" + this.ai.getAndIncrement();
        Thread t = new Thread(r, name);
        t.setDaemon(this.daemon);
        return t;
    }
}

