/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.jctools.queues.MpscLinkedQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationContext
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationContext.class);
    private static final AtomicReferenceFieldUpdater<SynchronizationContext, Thread> THREAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SynchronizationContext.class, Thread.class, "thread");
    private final MessagePassingQueue<Runnable> q;
    private volatile Thread thread;

    private SynchronizationContext(MessagePassingQueue<Runnable> q) {
        this.q = q;
    }

    public static SynchronizationContext create() {
        return new SynchronizationContext((MessagePassingQueue<Runnable>)new MpscLinkedQueue());
    }

    public static SynchronizationContext create(int chunkSize) {
        return new SynchronizationContext((MessagePassingQueue<Runnable>)new MpscUnboundedArrayQueue(chunkSize));
    }

    public static SynchronizationContext create(int initialCapacity, int maxCapacity) {
        return new SynchronizationContext((MessagePassingQueue<Runnable>)new MpscChunkedArrayQueue(initialCapacity, maxCapacity));
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.executeLater(command);
        this.drain();
    }

    public void executeLater(@Nonnull Runnable command) {
        if (!this.q.offer((Object)command)) {
            throw new IllegalStateException("queue is full");
        }
    }

    public boolean isCurrentThreadInContext() {
        return this.thread == Thread.currentThread();
    }

    public void drain() {
        Thread thread = Thread.currentThread();
        MessagePassingQueue<Runnable> q = this.q;
        do {
            Runnable r;
            if (!THREAD_UPDATER.compareAndSet(this, null, thread)) {
                return;
            }
            while ((r = (Runnable)q.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    LOGGER.error("Exception caught when run task", e);
                }
            }
            THREAD_UPDATER.set(this, null);
        } while (!q.isEmpty());
    }
}

