/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationContext2
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationContext2.class);
    private static final AtomicReferenceFieldUpdater<SynchronizationContext2, Thread> THREAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SynchronizationContext2.class, Thread.class, "thread");
    private final ConcurrentLinkedQueue<Runnable> q = new ConcurrentLinkedQueue();
    private volatile Thread thread;

    public static SynchronizationContext2 create() {
        return new SynchronizationContext2();
    }

    @Override
    public void execute(@Nonnull Runnable command) {
        this.executeLater(command);
        this.drain();
    }

    public void executeLater(@Nonnull Runnable command) {
        if (!this.q.offer(command)) {
            throw new IllegalStateException("queue is full");
        }
    }

    public boolean isCurrentThreadInContext() {
        return this.thread == Thread.currentThread();
    }

    public void drain() {
        Thread thread = Thread.currentThread();
        ConcurrentLinkedQueue<Runnable> q = this.q;
        do {
            Runnable r;
            if (!THREAD_UPDATER.compareAndSet(this, null, thread)) {
                return;
            }
            while ((r = q.poll()) != null) {
                try {
                    r.run();
                }
                catch (Throwable e) {
                    LOGGER.error("Exception caught when run task", e);
                }
            }
            THREAD_UPDATER.set(this, null);
        } while (!q.isEmpty());
    }
}

