/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config.bind;

import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;

public class Path {
    private final Token[] tokens;

    private Path(Token[] tokens) {
        this.tokens = tokens;
    }

    public static Path parse(String str) {
        int tokenBegin = 0;
        boolean start = false;
        ArrayList<Token> tokens = new ArrayList<Token>();
        block5: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '[': {
                    if (start) {
                        throw new IllegalStateException("already start");
                    }
                    if (tokenBegin != i) {
                        tokens.add(new Token(str, tokenBegin, i));
                    }
                    start = true;
                    tokenBegin = i + 1;
                    continue block5;
                }
                case ']': {
                    if (!start) {
                        throw new IllegalStateException("not started");
                    }
                    tokens.add(new Token(str, tokenBegin, i));
                    start = false;
                    tokenBegin = i + 1;
                    continue block5;
                }
                case '.': {
                    if (start) {
                        throw new IllegalStateException("already start");
                    }
                    if (tokenBegin != i) {
                        tokens.add(new Token(str, tokenBegin, i));
                    }
                    tokenBegin = i + 1;
                    continue block5;
                }
            }
        }
        if (start) {
            throw new IllegalStateException("need stop");
        }
        if (str.charAt(str.length() - 1) != ']') {
            tokens.add(new Token(str, tokenBegin, str.length()));
        }
        return new Path(tokens.toArray(new Token[tokens.size()]));
    }

    @Generated
    public String toString() {
        return "Path(tokens=" + Arrays.deepToString(this.tokens) + ")";
    }

    public static class Token {
        final String str;
        final int begin;
        final int end;
        String value;

        Token(String str, int begin, int end) {
            this.str = str;
            this.begin = begin;
            this.end = end;
            this.get();
        }

        String get() {
            if (this.value != null) {
                return this.value;
            }
            this.value = this.str.substring(this.begin, this.end);
            return this.value;
        }

        @Generated
        public String toString() {
            return "Path.Token(str=" + this.str + ", begin=" + this.begin + ", end=" + this.end + ", value=" + this.value + ")";
        }
    }
}

