/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.config.spring;

import com.xzchaoo.commons.basic.concurrent.OneThreadFactory;
import com.xzchaoo.commons.basic.config.MutableMapConfig;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateConfigTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateConfigTask.class);
    private final MutableMapConfig config;
    private final Supplier<Map<String, String>> supplier;
    private final long mills;
    private ScheduledThreadPoolExecutor scheduler;

    public UpdateConfigTask(MutableMapConfig config, Supplier<Map<String, String>> supplier, Duration interval) {
        this.config = config;
        this.supplier = supplier;
        this.mills = interval.toMillis();
    }

    @PostConstruct
    public void start() {
        this.scheduler = new ScheduledThreadPoolExecutor(1, new OneThreadFactory("UpdateConfigTask"));
        this.scheduler.scheduleWithFixedDelay(this::execute, this.mills, this.mills, TimeUnit.MILLISECONDS);
    }

    private void execute() {
        try {
            Map<String, String> map = this.supplier.get();
            if (!map.equals(this.config.asMap())) {
                LOGGER.info("[config] changed from {} to {}", this.config.asMap(), map);
                this.config.setMap(map);
            }
        }
        catch (Throwable e) {
            LOGGER.error("[config] fail to get latest config from supplier", e);
        }
    }

    @PreDestroy
    public void stop() {
        this.scheduler.shutdownNow();
    }
}

