/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.diff;

import com.xzchaoo.commons.basic.function.TriConsumer;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class DiffUtils {
    private DiffUtils() {
    }

    public static <T> void diff(Iterable<T> left, Iterable<T> right, Predicate<T> leftContain, Predicate<T> rightContain, Consumer<T> leftOnly, Consumer<T> rightOnly, Consumer<T> intersection) {
        for (T t : left) {
            if (rightContain.test(t)) {
                intersection.accept(t);
                continue;
            }
            leftOnly.accept(t);
        }
        for (T t : right) {
            if (leftContain.test(t)) continue;
            rightOnly.accept(t);
        }
    }

    public static <K, V> void diff2(Map<K, V> left, Map<K, V> right, BiConsumer<K, V> leftOnly, BiConsumer<K, V> rightOnly, TriConsumer<K, V, V> intersection) {
        for (Map.Entry<K, V> e : left.entrySet()) {
            K k = e.getKey();
            V v = e.getValue();
            if (right.containsKey(k)) {
                intersection.accept(k, v, right.get(k));
                continue;
            }
            leftOnly.accept(k, v);
        }
        for (Map.Entry<K, V> e : right.entrySet()) {
            if (left.containsKey(e.getKey())) continue;
            rightOnly.accept(e.getKey(), e.getValue());
        }
    }
}

