/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.dispose;

import com.xzchaoo.commons.basic.dispose.Disposable;
import com.xzchaoo.commons.basic.dispose.Disposables;
import java.util.concurrent.atomic.AtomicReference;

class SwapDisposable
extends AtomicReference<Disposable>
implements Disposable.Swap {
    SwapDisposable() {
    }

    @Override
    public void dispose() {
        Disposable d = (Disposable)this.get();
        if (d != null && d != Disposables.DISPOSED) {
            this.lazySet(Disposables.DISPOSED);
            d.dispose();
        }
    }

    @Override
    public boolean isDisposed() {
        return Disposables.isDisposed((Disposable)this.get());
    }

    @Override
    public void update(Disposable d) {
        this.update0(d, true);
    }

    @Override
    public void replace(Disposable d) {
        this.update0(d, false);
    }

    private void update0(Disposable d, boolean disposePrev) {
        block4: {
            Disposable old;
            do {
                if ((old = (Disposable)this.get()) == d) {
                    return;
                }
                if (old == null || !old.isDisposed()) continue;
                if (old != Disposables.DISPOSED) {
                    this.lazySet(Disposables.DISPOSED);
                }
                if (d != null) {
                    d.dispose();
                }
                return;
            } while (!this.compareAndSet(old, d));
            if (!disposePrev || old == null) break block4;
            old.dispose();
        }
    }
}

