/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.drainloop;

import com.xzchaoo.commons.basic.drainloop.DrainLoop;
import java.util.function.Consumer;
import org.jctools.queues.MpscChunkedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpscDrainLoop<T>
extends DrainLoop {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpscDrainLoop.class);
    private final MpscChunkedArrayQueue<T> q;
    private final Consumer<T> consumer;

    public MpscDrainLoop(int queueSize, Consumer<T> consumer) {
        this.q = new MpscChunkedArrayQueue(queueSize);
        this.consumer = consumer;
    }

    public boolean add(T t) {
        if (!this.q.add(t)) {
            return false;
        }
        this.drainLoop();
        return true;
    }

    @Override
    protected void drainLoop0() {
        Object t;
        while ((t = this.q.relaxedPoll()) != null) {
            try {
                this.consumer.accept(t);
            }
            catch (Throwable e) {
                LOGGER.error("Exception caught when consume element", e);
            }
        }
    }
}

